/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.pulsate.provider;

import de.lessvoid.nifty.tools.pulsate.PulsatorProvider;
import java.util.Properties;

public class RectanglePulsator
implements PulsatorProvider {
    private float period;
    private float startTime;

    @Override
    public void initialize(Properties parameter) {
        this.period = Float.parseFloat(parameter.getProperty("period", "1000"));
    }

    @Override
    public float getValue(long msTime) {
        float delta = msTime - (long)this.startTime;
        double t = Math.PI * (double)delta / (double)this.period;
        double sin = Math.sin(t);
        double signum = Math.signum(sin);
        double s = signum + 1.0;
        return (float)s / 2.0f;
    }

    @Override
    public void reset(long msTime) {
        this.startTime = msTime;
    }
}

